/***************************************************************************
 *   Copyright (C) 2003 by Daniel Amkreutz                                 *
 *   aixpresso@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#include "kpegg.h"
#include "kpeggdig.h"

#include <stdlib.h>
#include <fstream.h>

#include <qvariant.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlcdnumber.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qpicture.h>

unsigned char buffer[4096];
int error;
int density = 3;
int pen_x = 0;
int pen_y = 28;


kpegg::kpegg(QWidget* parent, const char* name, bool modal, WFlags fl)
    : kpeggdig(parent,name, modal,fl)
{

  status->setText("Welcome to Kpegg 0.1a\n(C)2003 Daniel Amkreutz <aixpresso@web.de>\nInitializing ...");

 show_density->display(density);
 sel_density->setValue(density);

 sel_font->insertItem("Helvetica",-1);
 sel_font->insertItem("Times",-1);
 sel_font->insertItem("Courier",-1);

 sel_size->insertItem("6",-1);
 sel_size->insertItem("8",-1);
 sel_size->insertItem("10",-1);
 sel_size->insertItem("11",-1);
 sel_size->insertItem("12",-1);
 sel_size->insertItem("14",-1);
 sel_size->insertItem("18",-1);
 sel_size->insertItem("20",-1);

 status->append("Ready.");
 status->scrollToBottom();
}

kpegg::~kpegg()
{}

/*$SPECIALIZATION$*/
void kpegg::set_density()
{

 density = sel_density->value();
}

int kpegg::print_label()
{

 int i=0;
 status->append("Writing Imagedata to /tmp/kpegg_label.out ...");
 std::ofstream file("/tmp/kpegg_label.out");
 for (i = 1; i < 4097; i++){

  file.put(buffer[i]);
 }
 file.close();

 status->append("Executing 'pegg' ...");

 if (density == 1) system("pegg -1 /tmp/kpegg_label.out");
 if (density == 2) system("pegg -2 /tmp/kpegg_label.out");
 if (density == 3) system("pegg -3 /tmp/kpegg_label.out");
 if (density == 4) system("pegg -4 /tmp/kpegg_label.out");
 if (density == 5) system("pegg -5 /tmp/kpegg_label.out");

 status->append("Ready.");
 status->scrollToBottom();
}


int kpegg::render_text()
{
  QPixmap pixmap(64,512,1);
  QImage image;
  QPainter p;

  int size=0,
      i=0,
      n=0;

  if(sel_size->currentText() == "6"){
   pen_y = 19;
   size = 6;
  }

  if(sel_size->currentText() == "8"){
   pen_y = 19;
   size = 8;
  }

  if(sel_size->currentText() == "10"){
   pen_y = 19;
   size = 10;
  }

  if(sel_size->currentText() == "11"){
   pen_y = 19;
   size = 11;
  }

  if(sel_size->currentText() == "12"){
   pen_y = 19;
   size = 12;
  }

  if(sel_size->currentText() == "14"){
   pen_y = 20;
   size = 14;
  }

  if(sel_size->currentText() == "18"){
   pen_y = 21;
   size = 18;
  }

  if(sel_size->currentText() == "20"){
   pen_y = 22;
   size = 20;
  }


  QFont f( sel_font->currentText(), size, QFont::Bold );


  p.begin(preview);
  p.eraseRect(0,0,256,32);
  p.moveTo(pen_x,pen_y);
  p.setFont(f);
  p.drawText(pen_x,pen_y, text_input->text(),-1);
  p.end();

  p.begin(&pixmap);
  p.eraseRect(0,0,64,512);
  p.rotate(270);
  p.scale(2,2);
  p.setFont(f);
  p.drawText(-256,pen_y+3, text_input->text(),-1);

  p.end();

  image= pixmap.convertToImage();

  for (i = 1; i < 4097; i++) {

   buffer[i] = 0x00;
  }

  for (i = 1; i < 513; i++) {

    for (n = 0; n < 7; n++) {
      buffer[((i-1)*8)+n] = *(image.scanLine(511-(i-1))+n);
    }
  }

}



#include "kpegg.moc"

