#!/usr/bin/perl -w

#######################################################################################
# xbm2crw 0.1a - A converter for xbm to casio raw files to print with pegg
# (C)2004 Daniel Amkreutz
#
#        Only 1Bit Black&White XBMs with a size of 64x512 (wxh) are valid !!!
#
#        This program is distributed in the hope that it will be useful,
#        but WITHOUT ANY WARRANTY; without even the implied warranty of
#        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
#	You may use this program for whatever you want as long the above written
#	text remains.
#
#
#  Print the .crw file using pegg
#
#########################################################################################

my @split;
my @bitmap;
my @printmap;
my $char=0;
my $row=0;
my $size =0;

if (@ARGV == 0) {
  print "\nxbm2crw Version 0.1a (C) 2004 Daniel Amkreutz\n";
  print "convert an black&white xbm file to a casio raw file\n\n";
  print "\tXBM format:\t1-Bit black&white\n";
  print "\t\t\twidth=64dots\n";
  print "\t\t\theight=512dots\n";
  print "\nERROR! Wrong number of Parameters.\n\n\tUsage: xbm2crw.pl <FILENAME>\n\n";
  exit;
}

print "xbm2crw Version 0.1a (C) 2004 Daniel Amkreutz\n";
print "converting...";

open(READ, "<",$ARGV[0]) || die "Could not open file!\n\n";
print "Converting\n";

my @Lines = <READ>;
close(READ);

foreach(@Lines){

  @split=split(/,/,$_);

  if($#split > 0) {

      for(my $col = 0; $col <= $#split; $col++) {
	$split[$col]=~ s/ //g;
	$split[$col]=~ s/}//g;
        $split[$col]=~ s/{//g;
	$split[$col]=~ s/;//g;
        $split[$col]=~ s/\n//g;
	$bitmap[$row*12+$col] = $split[$col];
      }

  $row++;
  }

}


for (my $row=0; $row<=511;$row++){
  for(my $col = 0; $col<=7;$col++){
    $printmap[$row*8+$col] = $bitmap[4095 - ($row+1)*8 + $col+1];
    $a = $row*8+$col;
    $b = 4095 - ($row+1)*8 + $col+1;
  }
}

open(WRITE, ">".$ARGV[0].".crw") || die "Could not open file! \n\n";


foreach(@printmap){
  print WRITE pack("C",hex($_));
}
close(WRITE);

$size=$#printmap+1;

if ($size !=4096){
  print "WARNING: Filesize is not 64x512x8Bit = 4096 Bytes. Print will fail.\n";
  print "Perhaps wrong dimension or color depth!!\n\n";
}

print $size." Bytes written\n\n";




